import { StarXpandCommand } from "star-io10-web";

export class ReceiptSample11_Cafe_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(48.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            .styleInternationalCharacter(
              StarXpandCommand.Printer.InternationalCharacterType.Japan,
            )
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(48.0, 120.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    0.0,
                    0.0,
                    48.0,
                    120.0,
                  ),
                ) // 外枠
                .actionPrintRectangle(
                  new StarXpandCommand.Printer.PageModeRectangleParameter(
                    5.0,
                    5.0,
                    16.0,
                    13.0,
                  ),
                ) // 収入印紙
                .stylePrintDirection(
                  StarXpandCommand.Printer.PageModePrintDirection.TopToBottom,
                )
                .styleHorizontalPositionTo(7.0)
                .styleVerticalPositionTo(30.0)
                .actionPrintText("収　入")
                .styleHorizontalPositionTo(7.0)
                .styleVerticalPositionTo(37.0)
                .actionPrintText("印　紙")
                .styleHorizontalPositionTo(0.0)
                .styleVerticalPositionTo(5.0)
                .add(
                  new StarXpandCommand.PageModeBuilder()
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .actionPrintText(
                      "領　収　証",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        19, // 20文字入りますが、中心位置の都合上19としています。
                        new StarXpandCommand.Printer.TextWidthParameter()
                          .setAlignment(
                            StarXpandCommand.Printer.TextAlignment.Center,
                          )
                          .setWidthType(
                            StarXpandCommand.Printer.TextWidthType.Full,
                          ),
                      ),
                    ),
                )
                .styleHorizontalPositionTo(100.0)
                .styleVerticalPositionTo(3.0)
                .actionPrintText("No.${number%04d}")
                .styleHorizontalPositionTo(80.0)
                .styleVerticalPositionTo(6.0)
                .add(
                  new StarXpandCommand.PageModeBuilder()
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 1),
                    )
                    .actionPrintText("${year%04d}")
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(1, 1),
                    )
                    .actionPrintText("年")
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 1),
                    )
                    .actionPrintText("${month%02d}")
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(1, 1),
                    )
                    .actionPrintText("月")
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 1),
                    )
                    .actionPrintText("${day%02d}")
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(1, 1),
                    )
                    .actionPrintText("日"),
                )
                .styleHorizontalPositionTo(4.0)
                .styleVerticalPositionTo(12.0)
                .add(
                  new StarXpandCommand.PageModeBuilder()
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .actionPrintText(
                      "${name}",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        7,
                        new StarXpandCommand.Printer.TextWidthParameter().setWidthType(
                          StarXpandCommand.Printer.TextWidthType.Full,
                        ),
                      ),
                    )
                    .actionPrintText("様")
                    .actionPrintRuledLine(
                      new StarXpandCommand.Printer.PageModeRuledLineParameter(
                        4.0,
                        16.0,
                        53.0,
                        16.0,
                      ).setThickness(0.2),
                    ),
                )
                .styleHorizontalPositionTo(76.0)
                .styleVerticalPositionTo(18.0)
                .actionPrintText("但し ")
                .actionPrintText(
                  "${description}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    12,
                    new StarXpandCommand.Printer.TextWidthParameter().setWidthType(
                      StarXpandCommand.Printer.TextWidthType.Full,
                    ),
                  ),
                )
                .styleHorizontalPositionTo(20.0)
                .styleVerticalPositionTo(20.0)
                .add(
                  new StarXpandCommand.PageModeBuilder()
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .actionPrintText(
                      "金${price}円",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        9,
                        new StarXpandCommand.Printer.TextWidthParameter()
                          .setAlignment(
                            StarXpandCommand.Printer.TextAlignment.Right,
                          )
                          .setWidthType(
                            StarXpandCommand.Printer.TextWidthType.Full,
                          ),
                      ),
                    )
                    .actionPrintRuledLine(
                      new StarXpandCommand.Printer.PageModeRuledLineParameter(
                        20.0,
                        24.0,
                        75.0,
                        24.0,
                      ).setThickness(0.2),
                    ),
                )
                .styleHorizontalPositionTo(24.0)
                .styleVerticalPositionTo(26.0)
                .actionPrintText("上記正に領収いたしました")
                .styleHorizontalPositionTo(24.0)
                .styleVerticalPositionBy(6.0)
                .actionPrintText("(税抜金額")
                .actionPrintText(
                  "\\${excluding_tax})",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    15,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .styleHorizontalPositionTo(24.0)
                .styleVerticalPositionBy(4.0)
                .actionPrintText("(消費税等")
                .actionPrintText(
                  "\\${tax})",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    15,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "cafe_template_coffee_cup.png",
                    65.0,
                    27.0,
                    80,
                  ),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(8.0, 30.0)
                    .setX(11.0)
                    .setY(76.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleHorizontalPositionTo(0.0)
                    .actionPrintText("${store_name}\n"),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(10.0, 44.0)
                    .setX(0.0)
                    .setY(62.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleHorizontalPositionTo(0.0)
                    .actionPrintText(
                      "${address}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        29, // 全角文字を考慮する必要
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    )
                    .actionPrintText(
                      "TEL ${telephone_number}\n",
                      new StarXpandCommand.Printer.TextParameter().setWidth(
                        29,
                        new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                          StarXpandCommand.Printer.TextAlignment.Center,
                        ),
                      ),
                    ),
                )
                .styleHorizontalPositionTo(110.0)
                .styleVerticalPositionTo(35.0)
                .actionPrintText("印"),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "number" : 9,
    "year" : 2013,
    "month" : 1,
    "day" : 10,
    "name" : "静岡　太郎",
    "description" : "ご飲食代として",
    "price" : 2200,
    "excluding_tax" : 2000,
    "tax" : 200,
    "store_name" : "珈琲の店スター\\n　　静岡店",
    "address" : "XXX県XXX市XXX町123-1",
    "telephone_number" : "01-2345-6789"
}`,
    );
  }
}
